/*
 * Decompiled with CFR 0.152.
 */
package rendering;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import navigationView.JElementFactory;

public class TextMatrixCreator {
    private boolean[][] textMatrix;
    private int width;

    public TextMatrixCreator(String text, int height, int scaleFactor) {
        this.createTextMatrix(text, height, scaleFactor);
    }

    public boolean[][] getTextMatrix() {
        return this.textMatrix;
    }

    public int getWidth() {
        return this.width;
    }

    private void createTextMatrix(String text, int height, int scaleFactor) {
        BufferedImage image = new BufferedImage(300 * scaleFactor * text.length(), height, 10);
        Graphics2D g2D = (Graphics2D)image.getGraphics();
        Font font = new Font("Serif", 0, (int)((double)height * 0.85));
        g2D.setFont(font);
        this.width = g2D.getFontMetrics().stringWidth(text) + 60 * scaleFactor;
        image = new BufferedImage(this.width, height, 10);
        g2D = (Graphics2D)image.getGraphics();
        g2D.setFont(font);
        g2D.drawString(text, 30 * scaleFactor, (int)((double)(height / 3) * 2.2));
        JFrame testFrame = new JFrame();
        JLabel testLabel = new JLabel();
        testFrame.add(testLabel);
        testLabel.setIcon(new ImageIcon(image));
        JElementFactory.makeFullScreen(testFrame, true);
        this.textMatrix = this.imageToMatrix(image);
    }

    private boolean[][] imageToMatrix(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int[] pixelFeld = new int[width * height];
        try {
            PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, width, height, pixelFeld, 0, width);
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException ie) {
            return null;
        }
        int i = 0;
        while (i < pixelFeld.length) {
            int n = i++;
            pixelFeld[n] = pixelFeld[n] & 0xFF;
        }
        boolean[][] bildMatrix = new boolean[width][height];
        int x = 0;
        int y = 0;
        for (int i2 = 0; i2 < width * height; ++i2) {
            if (x == width) {
                x = 0;
                ++y;
            }
            bildMatrix[x][y] = pixelFeld[i2] > 0;
            ++x;
        }
        return bildMatrix;
    }
}

