/*
 * Decompiled with CFR 0.152.
 */
package rendering.thread;

import game.utils.IniFileParser;
import game.utils.LogHandler;
import gameServer.ClientSide.GameCoordinatorConnection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.Semaphore;
import labyrinthField.Treasure;
import labyrinthField.TreasureType;
import navigationView.GameState;
import navigationView.LabyrinthNavigationView;
import navigationView.PlayerEffect;
import navigationView.Renderable;
import navigationView.ViewModel;
import navigationView.ViewModelEvaluator;
import network.ReadWriteHelper;
import network.VictoryMetaData;

public class GameThread
extends Thread {
    private ViewModel viewModel;
    private LabyrinthNavigationView view;
    private LabyrinthNavigationView partnerView;
    private Renderable renderable;
    private static Semaphore semaphore = new Semaphore(1);

    public GameThread(LabyrinthNavigationView view, LabyrinthNavigationView partnerView, Renderable renderable) {
        this.viewModel = view.getViewModel();
        this.view = view;
        this.partnerView = partnerView;
        this.renderable = renderable;
    }

    @Override
    public void run() {
        try {
            switch (this.viewModel.getGameState()) {
                case PLAYING: {
                    if (this.viewModel.isGoalReached()) {
                        VictoryMetaData victoryMetaData = this.view.showVictory();
                        this.uploadScore(victoryMetaData);
                        break;
                    }
                    this.viewModel.step();
                    this.checkTreasures();
                    break;
                }
            }
        }
        catch (Exception e) {
            LogHandler.notifyException(e);
            this.renderable.showMessageDialog("An unknown error occurred.");
            this.view.close();
        }
    }

    private void uploadScore(VictoryMetaData victoryMetaData) {
        if (this.viewModel.isBestOfThenMode() && this.viewModel.getGameState() == GameState.END_SCREEN && this.viewModel.getPlayer() != null) {
            try {
                semaphore.acquire();
            }
            catch (InterruptedException e) {
                LogHandler.notifyException(e);
            }
            GameCoordinatorConnection gameCoordinatorConnection = new GameCoordinatorConnection();
            IniFileParser iniFileParser = IniFileParser.getInstance();
            if (iniFileParser.isUploadOfflineScorePossible() && gameCoordinatorConnection.connect(3000)) {
                try {
                    ReadWriteHelper.writeSocketMessage(gameCoordinatorConnection.getClientSocket(), "sendScore;" + iniFileParser.getOfflineScoreSecret() + ";" + this.viewModel.getPlayer().getName() + ";" + victoryMetaData.getOverallScore());
                    gameCoordinatorConnection.getClientSocket().setSoTimeout(100);
                    ReadWriteHelper.readSocketObject(gameCoordinatorConnection.getClientSocket());
                }
                catch (IOException | ClassNotFoundException e) {
                    LogHandler.notifyException(e);
                }
            }
            gameCoordinatorConnection.disconnect(true);
            semaphore.release();
        }
    }

    private void checkTreasures() {
        for (Treasure treasure : this.viewModel.getLeftTreasuresList()) {
            if (this.viewModel == null || !(treasure.getPoint().getDistance(this.viewModel.getCurrentPosition()) < (double)(8 * this.viewModel.getScaleFactor()))) continue;
            ArrayList<LabyrinthNavigationView> viewList = new ArrayList<LabyrinthNavigationView>();
            viewList.add(this.view);
            viewList.add(this.partnerView);
            for (LabyrinthNavigationView labyrinthNavigationView : viewList) {
                labyrinthNavigationView.getViewModel().pickUpTreasure(treasure.getId());
            }
            int playerNumber = this.viewModel.getPlayerNumber();
            long effectElapseTime = new Date().getTime() + 30000L;
            if (treasure.getTreasureType() == TreasureType.SLOW_OTHERS) {
                effectElapseTime = new Date().getTime() + 15000L;
            }
            long showUntilTime = new Date().getTime() + 10000L;
            switch (treasure.getTreasureType()) {
                case SPEED_SELF: 
                case SLOW_SELF: 
                case SLOW_OTHERS: {
                    PlayerEffect playerEffect = new PlayerEffect(treasure.getTreasureType(), effectElapseTime, playerNumber, playerNumber, treasure.getId(), showUntilTime);
                    this.viewModel.addPlayerEffect(playerEffect);
                    this.partnerView.getViewModel().addPlayerEffect(playerEffect);
                    break;
                }
                case SLOW_FIRST: {
                    int firstPlayerNumber = ViewModelEvaluator.getViewModelWithShortestDistanceToGoal(ViewModelEvaluator.extractViewModels(viewList)).getPlayerNumber();
                    PlayerEffect playerEffect = new PlayerEffect(treasure.getTreasureType(), effectElapseTime, playerNumber, firstPlayerNumber, treasure.getId(), showUntilTime);
                    this.viewModel.addPlayerEffect(playerEffect);
                    this.partnerView.getViewModel().addPlayerEffect(playerEffect);
                    break;
                }
                case SHOW_WAY_TO_GOAL: {
                    effectElapseTime = new Date().getTime() + 5000L;
                    showUntilTime = new Date().getTime() + 10000L;
                    this.viewModel.addPlayerEffect(new PlayerEffect(TreasureType.SHOW_WAY_TO_GOAL, effectElapseTime, playerNumber, playerNumber, treasure.getId(), showUntilTime));
                    break;
                }
                case INVERT: {
                    effectElapseTime = new Date().getTime() + 10000L;
                    this.viewModel.addPlayerEffect(new PlayerEffect(TreasureType.INVERT, effectElapseTime, playerNumber, playerNumber, treasure.getId(), showUntilTime));
                    break;
                }
                case CHANGE: {
                    this.viewModel.switchPositions(this.partnerView.getViewModel());
                    this.viewModel.addPlayerEffect(new PlayerEffect(TreasureType.CHANGE, showUntilTime, playerNumber, playerNumber, treasure.getId(), showUntilTime));
                }
            }
            return;
        }
    }
}

