/*
 * Decompiled with CFR 0.152.
 */
package rendering.thread;

import game.utils.LogHandler;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;
import navigationView.MultiplayerClientView;
import network.ReadWriteHelper;
import network.SerializableNetworkObject;
import network.UpdateRecord;
import test.LabeledTestTimer;

public class MultiplayerClientDatagramListenerThread
extends Thread {
    private MultiplayerClientView multiPlayerClientSplit;
    private DatagramSocket client;
    private boolean isActive = true;
    private HashMap<Integer, Integer> datagramCountMap = new HashMap();
    private boolean firstMessageReceived = false;
    private Socket tcpSocket;

    public MultiplayerClientDatagramListenerThread(MultiplayerClientView multiPlayerClientSplit, DatagramSocket client, Socket tcpSocket) {
        this.multiPlayerClientSplit = multiPlayerClientSplit;
        this.client = client;
        this.tcpSocket = tcpSocket;
    }

    @Override
    public void run() {
        while (this.isActive) {
            LabeledTestTimer.start("data interval");
            try {
                SerializableNetworkObject object = ReadWriteHelper.readDatagramSocketObject(this.client);
                if (object.getUpdateRecordList() != null) {
                    ArrayList<UpdateRecord> updateRecordList = object.getUpdateRecordList();
                    for (UpdateRecord updateRecord : updateRecordList) {
                        int labyrinthNumber = updateRecord.getLabyrinthNumber();
                        if (this.datagramCountMap.containsKey(labyrinthNumber) && updateRecord.getDatagramCounter() <= this.datagramCountMap.get(labyrinthNumber) || labyrinthNumber == this.multiPlayerClientSplit.getPlayerNumber()) continue;
                        this.multiPlayerClientSplit.updateView(updateRecord);
                        this.datagramCountMap.put(labyrinthNumber, updateRecord.getDatagramCounter());
                    }
                    if (!this.firstMessageReceived) {
                        ReadWriteHelper.writeSocketMessage(this.tcpSocket, "UDP works;");
                        this.firstMessageReceived = true;
                    }
                }
            }
            catch (SocketException e) {
                this.client.close();
                this.isActive = false;
            }
            catch (IOException e) {
                LogHandler.notifyException(e);
                this.client.close();
                this.isActive = false;
            }
            catch (Exception e) {
                LogHandler.notifyException(e);
                this.client.close();
                this.isActive = false;
                this.multiPlayerClientSplit.showMessageDialog("An unknown error occurred. Please restart the application");
                this.multiPlayerClientSplit.close(true);
                return;
            }
            LabeledTestTimer.stop("data interval");
        }
    }
}

