/*
 * Decompiled with CFR 0.152.
 */
package rendering.thread;

import game.utils.LogHandler;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Date;
import menu.GameCoordinatorApplicationState;
import navigationView.MultiplayerClientView;
import navigationView.MultiplayerClientViewColored;
import network.ReadWriteHelper;
import network.SerializableNetworkObject;
import network.UpdateRecord;

public class MultiplayerClientListenerThread
extends Thread {
    private MultiplayerClientView multiPlayerClientView;
    private Socket client;
    private boolean isActive = true;
    private GameCoordinatorApplicationState gameCoordinatorApplicationState;

    public MultiplayerClientListenerThread(MultiplayerClientView multiPlayerClientView, Socket client, GameCoordinatorApplicationState gameCoordinatorApplicationState) {
        this.multiPlayerClientView = multiPlayerClientView;
        this.client = client;
        this.gameCoordinatorApplicationState = gameCoordinatorApplicationState;
    }

    @Override
    public void run() {
        while (this.gameCoordinatorApplicationState != null && this.gameCoordinatorApplicationState.getGameCoordinatorClientListener().isRunning()) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        while (this.isActive) {
            try {
                SerializableNetworkObject object = ReadWriteHelper.readSocketObject(this.client);
                if (object.getVictoryMetaDataList() != null) {
                    this.multiPlayerClientView.showVictory(object.getVictoryMetaDataList());
                    continue;
                }
                if (object.getLabyrinthFieldMetaData() != null) {
                    this.multiPlayerClientView.setLabyrinthFieldMetaData(object.getLabyrinthFieldMetaData());
                    ReadWriteHelper.writeSocketMessage(this.client, "ACK;");
                    continue;
                }
                if (object.getCommand() != null) {
                    if (object.getCommand().equals("disconnect;")) {
                        this.multiPlayerClientView.close(false);
                        this.multiPlayerClientView.showMessageDialog("Connection closed.");
                        this.isActive = false;
                    }
                    if (object.getCommand().startsWith("startRound;")) {
                        this.multiPlayerClientView.startTheGame();
                        continue;
                    }
                    if (object.getCommand().startsWith("timeOutUpdate;")) {
                        long timeout = Integer.parseInt(object.getCommand().split(";")[1]) == 0 ? 0L : new Date().getTime() + 60000L;
                        this.multiPlayerClientView.setTimeout(timeout);
                    }
                    if (object.getCommand().equals("makeHost;") && this.multiPlayerClientView instanceof MultiplayerClientViewColored) {
                        ((MultiplayerClientViewColored)this.multiPlayerClientView).makeHost();
                    }
                }
                if (object.getUpdateRecordList() != null) {
                    ArrayList<UpdateRecord> updateRecordList = object.getUpdateRecordList();
                    for (UpdateRecord updateRecord : updateRecordList) {
                        this.multiPlayerClientView.updateView(updateRecord);
                    }
                }
                if (object.getPickupTreasureEvent() == null) continue;
                this.multiPlayerClientView.applyPickupTreasureEvent(object.getPickupTreasureEvent());
            }
            catch (SocketException e) {
                this.isActive = false;
            }
            catch (IOException | ClassNotFoundException e) {
                LogHandler.notifyException(e);
                this.isActive = false;
            }
            catch (Exception e) {
                LogHandler.notifyException(e);
                this.isActive = false;
                this.multiPlayerClientView.showMessageDialog("An unknown error occurred. Please restart the application");
                this.multiPlayerClientView.close(true);
                return;
            }
        }
    }
}

