/*
 * Decompiled with CFR 0.152.
 */
package rendering.thread;

import game.ShutdownGameCoordinator;
import game.utils.LogHandler;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketException;
import javax.swing.JOptionPane;
import navigationView.LabyrinthNavigationView;
import network.KeyEventWrapper;
import network.Player;
import network.ReadWriteHelper;
import network.SerializableNetworkObject;
import network.ServerConnection;
import network.WayVector;
import rendering.thread.LoopThread;

public class MultiplayerHostListenerThread
extends Thread
implements LoopThread {
    private Player player;
    private LabyrinthNavigationView view;
    private boolean isActive = true;
    private ServerConnection connection;
    private boolean isAcknowledged = false;
    private LabyrinthNavigationView hostView;
    private boolean resendDisconnect = false;

    public MultiplayerHostListenerThread(Player player, LabyrinthNavigationView view, ServerConnection connection) {
        this.player = player;
        this.view = view;
        this.connection = connection;
    }

    @Override
    public void stopThread() {
        this.isActive = false;
    }

    @Override
    public void run() {
        while (this.isActive) {
            try {
                SerializableNetworkObject object = ReadWriteHelper.readSocketObject(this.player.getClient());
                if (object.getKeyWrapper() != null) {
                    KeyEventWrapper keyEventWrapper = object.getKeyWrapper();
                    if (keyEventWrapper.isPushed()) {
                        this.view.keyPressedKeyCode(keyEventWrapper.getKeyCode());
                    } else {
                        this.view.keyReleasedKeyCode(keyEventWrapper.getKeyCode());
                    }
                }
                if (object.getWayVector() != null) {
                    WayVector wayVector = object.getWayVector();
                    this.view.getViewModel().followWayVector(wayVector);
                }
                if (object.getCommand() == null) continue;
                if (object.getCommand().equals("ACK;")) {
                    this.isAcknowledged = true;
                }
                if (object.getCommand().equals("disconnect;")) {
                    if (this.resendDisconnect) {
                        ReadWriteHelper.writeSocketMessage(this.player.getClient(), "disconnect;");
                    }
                    this.disconnectPlayer();
                }
                if (object.getCommand().equals("UDP works;")) {
                    this.connection.markUdpAsWorking(this.player.getPlayerNumber());
                }
                if (!object.getCommand().equals("Enter;") || this.hostView == null) continue;
                this.hostView.playerPressedEnter(this.player.getPlayerNumber(), this.connection.getNumberOfConnectedPlayers());
            }
            catch (EOFException | SocketException e) {
                this.stopThread();
            }
            catch (IOException | ClassNotFoundException e) {
                LogHandler.notifyException(e);
                this.stopThread();
            }
            catch (Exception e) {
                LogHandler.notifyException(e);
                this.stopThread();
                if (this.hostView == null) {
                    JOptionPane.showMessageDialog(this.view, "An unknown error occurred. Please restart the application");
                }
                this.view.close();
                return;
            }
        }
    }

    public void disconnectPlayer() throws IOException {
        this.view.markAsDisconnected();
        this.stopThread();
        this.connection.disconnectPlayer(this.player);
        if (this.player.isHost()) {
            for (Player newHost : this.connection.getPlayerList()) {
                if (newHost.isDisconnected()) continue;
                ReadWriteHelper.writeSocketMessage(newHost.getClient(), "makeHost;");
                newHost.setHost(true);
                break;
            }
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public Player getPlayer() {
        return this.player;
    }

    public boolean isAcknowledged() {
        return this.isAcknowledged;
    }

    public void enableWaitForAcknowledge() {
        this.isAcknowledged = false;
    }

    public void setNavigationView(LabyrinthNavigationView hostView) {
        this.hostView = hostView;
    }

    public void registerShutdownGameCoordinator(ShutdownGameCoordinator shutdownGameCoordinator) {
        shutdownGameCoordinator.addLoopThread(this);
    }

    public void resendDisconnect() {
        this.resendDisconnect = true;
    }
}

