/*
 * Decompiled with CFR 0.152.
 */
package rendering.thread;

import game.utils.LogHandler;
import java.util.HashMap;
import labyrinthField.Point;
import navigationView.LabyrinthNavigationView;
import navigationView.MultiplayerHostViewColored;
import test.LabeledTestTimer;

public class MultiplayerHostRenderThread
extends Thread {
    private HashMap<Integer, Point> playerPositionMap;
    private MultiplayerHostViewColored hostView;
    private LabyrinthNavigationView labyrinthView;
    private boolean hasUpdate;

    public MultiplayerHostRenderThread(HashMap<Integer, Point> playerPositionMap, MultiplayerHostViewColored hostView, LabyrinthNavigationView labyrinthView) {
        this.playerPositionMap = playerPositionMap;
        this.hostView = hostView;
        this.labyrinthView = labyrinthView;
        this.hasUpdate = false;
    }

    public void update() {
        this.hasUpdate = true;
    }

    @Override
    public void run() {
        try {
            if (this.labyrinthView.showContDown()) {
                return;
            }
            if (this.hasUpdate && this.hostView.hasOnePlayerPlaying()) {
                this.hasUpdate = false;
                LabeledTestTimer.start("render host");
                this.labyrinthView.getViewModel().renderLabyrinth(0, this.playerPositionMap, this.labyrinthView);
                LabeledTestTimer.stop("render host");
                this.hasUpdate = false;
            }
        }
        catch (Exception e) {
            LogHandler.notifyException(e);
            this.hostView.showDialog("An unknown error occurred. Please restart the application");
            this.hostView.close();
        }
    }
}

