/*
 * Decompiled with CFR 0.152.
 */
package rendering.thread;

import game.GameLogicException;
import game.utils.LogHandler;
import gameServer.ScoreBoard.ScorePointStorage;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JOptionPane;
import labyrinthField.Treasure;
import labyrinthField.TreasureType;
import navigationView.GameState;
import navigationView.LabyrinthNavigationView;
import navigationView.PickupTreasureEvent;
import navigationView.PlayerEffect;
import navigationView.ViewModel;
import navigationView.ViewModelEvaluator;
import network.Player;
import network.ServerConnection;
import network.VictoryMetaData;
import test.LabeledTestTimer;

public class NetworkGameThread
extends Thread {
    private ArrayList<LabyrinthNavigationView> viewList;
    private ServerConnection connection;
    private boolean splitscreen;
    private int numberOfWonPlayers = 0;
    public static final int timeout = 60;
    private HashMap<Integer, VictoryMetaData> victoryMetaDataMap = new HashMap();
    private ViewModel serverViewModel;

    public NetworkGameThread(ArrayList<LabyrinthNavigationView> viewList, ServerConnection connection, boolean splitScreen) {
        this.viewList = viewList;
        this.connection = connection;
        this.splitscreen = splitScreen;
    }

    @Override
    public void run() {
        LabeledTestTimer.start("game step");
        try {
            int i;
            block5: for (i = 0; i < this.viewList.size(); ++i) {
                LabyrinthNavigationView view = this.viewList.get(i);
                ViewModel viewModel = view.getViewModel();
                switch (viewModel.getGameState()) {
                    case PLAYING: {
                        long wonTime = viewModel.getTimeout();
                        if (viewModel.isGoalReached()) {
                            this.victoryMetaDataMap.put(i, view.createVictoryMetaData());
                            if (this.splitscreen) {
                                view.showVictory();
                                this.connection.showVictory(this.victoryMetaDataMap);
                            }
                            ++this.numberOfWonPlayers;
                            continue block5;
                        }
                        if (wonTime != 0L && wonTime + 60000L < new Date().getTime()) {
                            viewModel.createScoreByTimeout();
                            this.victoryMetaDataMap.put(i, view.createVictoryMetaData());
                            if (this.splitscreen) {
                                view.showVictory();
                                this.connection.showVictory(this.victoryMetaDataMap);
                            }
                            ++this.numberOfWonPlayers;
                            continue block5;
                        }
                        viewModel.step();
                        this.checkTreasures(viewModel);
                        continue block5;
                    }
                }
            }
            if (this.numberOfWonPlayers >= this.connection.getNumberOfConnectedPlayers() && this.numberOfWonPlayers > 0) {
                if (this.splitscreen) {
                    this.viewList.get(0).resetField();
                    this.victoryMetaDataMap = new HashMap();
                } else {
                    for (i = 0; i < this.viewList.size(); ++i) {
                        if (this.victoryMetaDataMap.containsKey(i)) continue;
                        this.victoryMetaDataMap.put(i, this.viewList.get(i).createVictoryMetaData());
                    }
                    if (this.serverViewModel == null) {
                        this.viewList.get(0).renderVictoryWithColor(this.victoryMetaDataMap, this.viewList.get(0).getViewModel().getPlayerNameList());
                    } else {
                        this.serverViewModel.setCurrentScore();
                    }
                    this.connection.showVictory(this.victoryMetaDataMap);
                    for (i = 0; i < this.viewList.size(); ++i) {
                        this.victoryMetaDataMap.get(i).resetDistanceAndTimeCount();
                    }
                    if (this.serverViewModel != null && this.serverViewModel.isBestOfThenMode()) {
                        this.serverViewModel.setGameState(this.getHostViewModel().getGameState());
                        if (this.getHostViewModel().getGameState() == GameState.END_SCREEN) {
                            ScorePointStorage scorePointStorage = new ScorePointStorage();
                            for (VictoryMetaData victoryMetaData : this.victoryMetaDataMap.values()) {
                                scorePointStorage.notifyScore(victoryMetaData.getOverallScore(), this.viewList.get(0).getViewModel().getPlayerNameList().get(victoryMetaData.getPlayerNumber()));
                            }
                            scorePointStorage.persist();
                        }
                        if (this.serverViewModel.isResetable()) {
                            this.serverViewModel.reset();
                        }
                    }
                }
                this.numberOfWonPlayers = 0;
            }
        }
        catch (Exception e) {
            LogHandler.notifyException(e);
            if (this.serverViewModel == null) {
                JOptionPane.showMessageDialog(this.viewList.get(0), "An unknown error occurred. Please restart the application");
            }
            this.connection.disconnect();
            this.viewList.get(0).close();
        }
        LabeledTestTimer.stop("game step");
    }

    private void checkTreasures(ViewModel viewModel) {
        for (Treasure treasure : this.viewList.get(0).getViewModel().getLeftTreasuresList()) {
            if (!(treasure.getPoint().getDistance(viewModel.getCurrentPosition()) < (double)(8 * viewModel.getScaleFactor()))) continue;
            for (LabyrinthNavigationView labyrinthNavigationView : this.viewList) {
                labyrinthNavigationView.getViewModel().pickUpTreasure(treasure.getId());
            }
            int playerNumber = viewModel.getPlayer().getPlayerNumber();
            long effectElapseTime = new Date().getTime() + 30000L;
            if (treasure.getTreasureType() == TreasureType.SLOW_OTHERS) {
                effectElapseTime = new Date().getTime() + 15000L;
            }
            long showUntilTime = new Date().getTime() + 10000L;
            PickupTreasureEvent pickupTreasureEvent = new PickupTreasureEvent(treasure.getId(), playerNumber);
            switch (treasure.getTreasureType()) {
                case SPEED_SELF: 
                case SLOW_OTHERS: 
                case SLOW_SELF: {
                    for (LabyrinthNavigationView labyrinthNavigationView : this.viewList) {
                        labyrinthNavigationView.getViewModel().addPlayerEffect(new PlayerEffect(treasure.getTreasureType(), effectElapseTime, playerNumber, playerNumber, treasure.getId(), showUntilTime));
                    }
                    break;
                }
                case SLOW_FIRST: {
                    int firstPlayerNumber = ViewModelEvaluator.getViewModelWithShortestDistanceToGoal(ViewModelEvaluator.extractViewModels(this.viewList)).getPlayerNumber();
                    for (LabyrinthNavigationView labyrinthNavigationView : this.viewList) {
                        labyrinthNavigationView.getViewModel().addPlayerEffect(new PlayerEffect(treasure.getTreasureType(), effectElapseTime, playerNumber, firstPlayerNumber, treasure.getId(), showUntilTime));
                    }
                    pickupTreasureEvent = new PickupTreasureEvent(treasure.getId(), playerNumber, firstPlayerNumber);
                    break;
                }
                case SHOW_WAY_TO_GOAL: {
                    effectElapseTime = new Date().getTime() + 5000L;
                    showUntilTime = new Date().getTime() + 5000L;
                    viewModel.addPlayerEffect(new PlayerEffect(TreasureType.SHOW_WAY_TO_GOAL, effectElapseTime, playerNumber, playerNumber, treasure.getId(), showUntilTime));
                }
                case INVERT: {
                    effectElapseTime = new Date().getTime() + 10000L;
                    viewModel.addPlayerEffect(new PlayerEffect(TreasureType.INVERT, effectElapseTime, playerNumber, playerNumber, treasure.getId(), showUntilTime));
                    break;
                }
                case CHANGE: {
                    int otherPlayerNumber = (int)(Math.random() * (double)(this.viewList.size() - 1));
                    if (otherPlayerNumber >= playerNumber) {
                        ++otherPlayerNumber;
                    }
                    ViewModel otherViewModel = this.viewList.get(otherPlayerNumber).getViewModel();
                    int counter = 0;
                    while (otherViewModel.getPlayer().isDisconnected()) {
                        if ((otherPlayerNumber += 1 % this.viewList.size()) == playerNumber) {
                            otherPlayerNumber += 1 % this.viewList.size();
                        }
                        otherViewModel = this.viewList.get(otherPlayerNumber).getViewModel();
                        if (++counter <= this.viewList.size()) continue;
                        otherViewModel = null;
                        break;
                    }
                    if (otherViewModel == null) break;
                    viewModel.switchPositions(otherViewModel);
                    viewModel.addPlayerEffect(new PlayerEffect(TreasureType.CHANGE, showUntilTime, playerNumber, playerNumber, treasure.getId(), showUntilTime));
                    pickupTreasureEvent = new PickupTreasureEvent(treasure.getId(), playerNumber, otherPlayerNumber);
                }
            }
            this.connection.distributeTreasurePickup(pickupTreasureEvent);
            return;
        }
    }

    private ViewModel getHostViewModel() {
        for (LabyrinthNavigationView view : this.viewList) {
            Player player = view.getViewModel().getPlayer();
            if (player == null || !player.isHost() || player.isDisconnected()) continue;
            return view.getViewModel();
        }
        throw new GameLogicException("no host found");
    }

    public void setServerViewModel(ViewModel viewModel) {
        this.serverViewModel = viewModel;
    }
}

