/*
 * Decompiled with CFR 0.152.
 */
package rendering.thread;

import game.ShutdownGameCoordinator;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class PeriodicExecutionService {
    private Thread thread;
    private ScheduledExecutorService scheduledExecutorService;
    private static ArrayList<ScheduledExecutorService> executorServiceArrayList = new ArrayList();
    private ShutdownGameCoordinator shutdownGameCoordinator;

    public PeriodicExecutionService(Thread thread) {
        this.thread = thread;
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        executorServiceArrayList.add(this.scheduledExecutorService);
    }

    public static void cancelAll() {
        for (ScheduledExecutorService scheduledExecutorService : executorServiceArrayList) {
            scheduledExecutorService.shutdown();
        }
    }

    public void start(long milliseconds, long delay) {
        this.scheduledExecutorService.scheduleAtFixedRate(this.thread, delay, milliseconds, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        this.scheduledExecutorService.shutdown();
        if (this.shutdownGameCoordinator != null) {
            this.shutdownGameCoordinator.stopThreads();
        }
    }

    public void stopWithoutCallback() {
        if (!this.scheduledExecutorService.isShutdown()) {
            this.scheduledExecutorService.shutdown();
        }
    }

    public PeriodicExecutionService registerShutdownGameCoordinator(ShutdownGameCoordinator shutdownGameCoordinator) {
        this.shutdownGameCoordinator = shutdownGameCoordinator;
        shutdownGameCoordinator.addPeriodicExecutionService(this);
        return this;
    }
}

