/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import labyrinthField.Field;
import labyrinthField.Point;
import test.TestView;

public class TestRenderer {
    public static void main(String[] args) {
        Field field = new Field(1920, 950, 1, "Garten\nCruising", false, 0);
        BufferedImage bufferedImage = TestRenderer.matrixToImage(field.getWayPointMatrix(), field.getStartPoint(), field.getGoal());
        TestView testView = new TestView();
        testView.show(bufferedImage);
        testView.setVisible(true);
    }

    private static BufferedImage matrixToImage(boolean[][] matrix, Point start, Point goal) {
        Point[] pointArray;
        int y;
        int x;
        int breite = matrix.length;
        int hoehe = matrix[0].length;
        int breiteFenster = breite + 100;
        int hoeheFenster = hoehe + 100;
        int[] pixelFeld = new int[breiteFenster * hoeheFenster];
        for (x = 0; x < breite; ++x) {
            for (y = 0; y < hoehe; ++y) {
                pixelFeld[(y + 50) * breiteFenster + x + 50] = matrix[x][y] ? 255 : 0;
            }
        }
        for (Point point : pointArray = new Point[]{start, goal}) {
            int newY;
            int newX;
            int yAround;
            int xAround;
            x = point.getxPosition();
            y = point.getyPosition();
            for (xAround = -10; xAround <= 10; ++xAround) {
                for (yAround = -10; yAround <= 10; ++yAround) {
                    if (xAround * xAround + yAround * yAround > 100) continue;
                    newX = x + xAround;
                    newY = y + yAround;
                    pixelFeld[(newY + 50) * breiteFenster + newX + 50] = 255;
                }
            }
            for (xAround = -3; xAround <= 3; ++xAround) {
                for (yAround = -3; yAround <= 3; ++yAround) {
                    if (xAround * xAround + yAround * yAround > 9) continue;
                    newX = x + xAround;
                    newY = y + yAround;
                    pixelFeld[(newY + 50) * breiteFenster + newX + 50] = 0;
                }
            }
        }
        BufferedImage image = new BufferedImage(breiteFenster, hoeheFenster, 10);
        WritableRaster raster = (WritableRaster)image.getData();
        raster.setPixels(0, 0, breiteFenster, hoeheFenster, pixelFeld);
        image.setData(raster);
        return image;
    }
}

